/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.illusivesoulworks.constructsarmory.ConstructsArmoryMod;
import com.james.tinkerscalibration.ConstructsArmoryIntegration;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingEvent;
import slimeknights.tconstruct.library.modifiers.impl.TotalArmorLevelModifier;
import slimeknights.tconstruct.library.tools.capability.TinkerDataCapability;
import slimeknights.tconstruct.library.tools.context.EquipmentContext;
import slimeknights.tconstruct.library.tools.helper.ToolDamageUtil;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.nbt.ToolStack;

public class ArmorBambooGrowingModifier
extends TotalArmorLevelModifier {
    private static final TinkerDataCapability.TinkerDataKey<Integer> BAMBOO = ConstructsArmoryMod.createKey((String)"bamboo_growing_armor");

    public ArmorBambooGrowingModifier() {
        super(BAMBOO);
        MinecraftForge.EVENT_BUS.addListener(ArmorBambooGrowingModifier::onUpdateApply);
    }

    private static void onUpdateApply(LivingEvent.LivingUpdateEvent evt) {
        EquipmentContext context;
        LivingEntity living = evt.getEntityLiving();
        if (!living.m_5833_() && (context = new EquipmentContext(living)).hasModifiableArmor() && !living.f_19853_.f_46443_ && living.m_6084_() && living.f_19797_ % 8 == 0) {
            living.getCapability(TinkerDataCapability.CAPABILITY).ifPresent(holder -> {
                int level = (Integer)holder.get(BAMBOO, (Object)0);
                if (level > 0) {
                    IToolStackView patt3837$temp;
                    IToolStackView patt3420$temp;
                    IToolStackView patt3002$temp;
                    ToolStack tool;
                    int bonus = ArmorBambooGrowingModifier.getBonus(living);
                    IToolStackView patt2585$temp = context.getToolInSlot(EquipmentSlot.LEGS);
                    if (patt2585$temp instanceof ToolStack) {
                        tool = (ToolStack)patt2585$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(ConstructsArmoryIntegration.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt3002$temp = context.getToolInSlot(EquipmentSlot.HEAD)) instanceof ToolStack) {
                        tool = (ToolStack)patt3002$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(ConstructsArmoryIntegration.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt3420$temp = context.getToolInSlot(EquipmentSlot.CHEST)) instanceof ToolStack) {
                        tool = (ToolStack)patt3420$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(ConstructsArmoryIntegration.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                    if ((patt3837$temp = context.getToolInSlot(EquipmentSlot.FEET)) instanceof ToolStack) {
                        tool = (ToolStack)patt3837$temp;
                        if (bonus > 0 && RANDOM.nextFloat() < (float)tool.getModifierLevel(ConstructsArmoryIntegration.bamboo_growing.get()) * 0.25f && !tool.isBroken()) {
                            ToolDamageUtil.repair((IToolStackView)tool, (int)bonus);
                        }
                    }
                }
            });
        }
    }

    private static int getBonus(LivingEntity living) {
        int bonus = 0;
        if (living.m_204029_(FluidTags.f_13131_)) {
            bonus = 4;
        } else if (living.m_20193_().m_46758_(living.m_142538_())) {
            bonus = 2;
        }
        return bonus;
    }
}

